--
-- Create/Update stored procedure
--

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_GetDoDFragmentFiles]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_GetDoDFragmentFiles]
GO

--
-- Delete roles/permissions
--

declare @apppageid int
select  @apppageid = ID
from STD_APPPAGE 
where CODE = 'EFR_DODFRAGMENT_REPORT'

if @apppageid > 0 
BEGIN
	delete ROLE_PERMISSIONS 
	where STD_APPPAGE_ID = @apppageid

	delete STD_APPPAGE  
	where ID = @apppageid
END

--
-- delete helper functions
--

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRNumberOfPatientsInDoDFragmentFile]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetEFRNumberOfPatientsInDoDFragmentFile]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEFRNumberOfRecordsInDoDFragmentFile]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[GetEFRNumberOfRecordsInDoDFragmentFile]
GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R6'
           ,'00'
           ,'001'
           ,0
           ,'20757  Develop Remaining Standard Reports not Implemented'
		   ,'rollback - Script will setup for the new DoD Fragment File report'
           ,'EFR'
           ,GETDATE())

GO
